/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class PhyrexianDreadnoughtSacrificeCost
extends CostImpl {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("any number of creatures with total power 12 or greater");

    public PhyrexianDreadnoughtSacrificeCost() {
        this.addTarget((Target)new TargetPermanent(0, Integer.MAX_VALUE, (FilterPermanent)filter, true));
        this.text = "sacrifice any number of creatures with total power 12 or greater";
    }

    private PhyrexianDreadnoughtSacrificeCost(PhyrexianDreadnoughtSacrificeCost cost) {
        super((CostImpl)cost);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        int sumPower = 0;
        if (this.getTargets().choose(Outcome.Sacrifice, controllerId, source.getSourceId(), source, game)) {
            for (UUID targetId : ((Target)this.getTargets().get(0)).getTargets()) {
                Permanent permanent = game.getPermanent(targetId);
                if (permanent == null || !permanent.sacrifice(source, game)) continue;
                sumPower += permanent.getPower().getValue();
            }
        }
        game.informPlayers("Sacrificed creatures with total power of " + sumPower);
        this.paid = sumPower >= 12;
        return this.paid;
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        Player controller = game.getPlayer(controllerId);
        if (controller == null) {
            return false;
        }
        int sumPower = 0;
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, controllerId, game)) {
            if (!controller.canPaySacrificeCost(permanent, source, controllerId, game)) continue;
            sumPower += permanent.getPower().getValue();
        }
        return sumPower >= 12;
    }

    public PhyrexianDreadnoughtSacrificeCost copy() {
        return new PhyrexianDreadnoughtSacrificeCost(this);
    }
}

