/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.events.PreventDamageEvent;
import mage.game.events.PreventedDamageEvent;
import mage.game.permanent.Permanent;

class PhyrexianHydraEffect
extends PreventionEffectImpl {
    PhyrexianHydraEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "If damage would be dealt to {this}, prevent that damage. Put a -1/-1 counter on {this} for each 1 damage prevented this way";
    }

    private PhyrexianHydraEffect(PhyrexianHydraEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public PhyrexianHydraEffect copy() {
        return new PhyrexianHydraEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent permanent;
        boolean retValue = false;
        PreventDamageEvent preventEvent = new PreventDamageEvent(event.getTargetId(), source.getSourceId(), source, source.getControllerId(), event.getAmount(), ((DamageEvent)event).isCombatDamage());
        int damage = event.getAmount();
        if (!game.replaceEvent((GameEvent)preventEvent)) {
            event.setAmount(0);
            game.fireEvent((GameEvent)new PreventedDamageEvent(event.getTargetId(), source.getSourceId(), source, source.getControllerId(), damage));
            retValue = true;
        }
        if ((permanent = game.getPermanent(source.getSourceId())) != null) {
            permanent.addCounters(CounterType.M1M1.createInstance(damage), source.getControllerId(), source, game);
        }
        return retValue;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (super.applies(event, source, game)) {
            return event.getTargetId().equals(source.getSourceId());
        }
        return false;
    }
}

