/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class PhyrexianIngesterBoostEffect
extends ContinuousEffectImpl {
    PhyrexianIngesterBoostEffect() {
        super(Duration.WhileOnBattlefield, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.BoostCreature);
        this.staticText = "{this} gets +X/+Y, where X is the exiled creature card's power and Y is its toughness";
    }

    private PhyrexianIngesterBoostEffect(PhyrexianIngesterBoostEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public PhyrexianIngesterBoostEffect copy() {
        return new PhyrexianIngesterBoostEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            return false;
        }
        for (UUID cardId : permanent.getImprinted()) {
            Card card = game.getCard(cardId);
            if (card == null) continue;
            permanent.addPower(card.getPower().getValue());
            permanent.addToughness(card.getToughness().getValue());
        }
        return true;
    }
}

