/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class PhyrexianIngesterImprintEffect
extends OneShotEffect {
    PhyrexianIngesterImprintEffect() {
        super(Outcome.Exile);
        this.staticText = "exile target nontoken creature";
    }

    private PhyrexianIngesterImprintEffect(PhyrexianIngesterImprintEffect effect) {
        super((OneShotEffect)effect);
    }

    public PhyrexianIngesterImprintEffect copy() {
        return new PhyrexianIngesterImprintEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null && sourceObject == null) {
            return false;
        }
        Permanent targetPermanent = game.getPermanent(source.getFirstTarget());
        if (targetPermanent == null) {
            return false;
        }
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        if (sourcePermanent != null) {
            UUID exileZoneId = CardUtil.getCardExileZoneId((Game)game, (Ability)source);
            String exileZoneName = sourceObject.getIdName() + " (Imprint)";
            controller.moveCardsToExile((Card)targetPermanent, source, game, true, exileZoneId, exileZoneName);
            sourcePermanent.imprint(targetPermanent.getId(), game);
        } else {
            controller.moveCardsToExile((Card)targetPermanent, source, game, true, null, "");
        }
        return true;
    }
}

