/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class PhyrexianPortalEffect
extends OneShotEffect {
    PhyrexianPortalEffect() {
        super(Outcome.Benefit);
        this.staticText = "If your library has ten or more cards in it, target opponent looks at the top ten cards of your library and separates them into two face-down piles. Exile one of those piles. Search the other pile for a card, put it into your hand, then shuffle the rest of that pile into your library";
    }

    private PhyrexianPortalEffect(PhyrexianPortalEffect effect) {
        super((OneShotEffect)effect);
    }

    public PhyrexianPortalEffect copy() {
        return new PhyrexianPortalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (controller != null && opponent != null) {
            if (controller.getLibrary().size() >= 10) {
                Card card;
                CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, 10));
                TargetCard target = new TargetCard(0, cards.size(), Zone.LIBRARY, new FilterCard("cards to put in the first pile"));
                ArrayList<Card> pile1 = new ArrayList<Card>();
                if (opponent.choose(Outcome.Neutral, (Cards)cards, target, source, game)) {
                    List targets = target.getTargets();
                    for (UUID targetId : targets) {
                        Card card2 = cards.get(targetId, game);
                        if (card2 == null) continue;
                        pile1.add(card2);
                        cards.remove(card2);
                    }
                }
                ArrayList pile2 = new ArrayList();
                pile2.addAll(cards.getCards(game));
                game.informPlayers(opponent.getLogName() + " separated the top 10 cards of " + controller.getLogName() + "'s library into two face-down piles (" + pile1.size() + " cards and " + pile2.size() + " cards)");
                boolean choice = controller.chooseUse(this.outcome, "Choose pile to search for a card (the other will be exiled):", source.getSourceObject(game).getLogName(), "Pile 1 (" + pile1.size() + " cards)", "Pile 2 (" + pile2.size() + " cards)", source, game);
                game.informPlayers(controller.getLogName() + " chooses to search the " + (choice ? "first" : "second") + " pile");
                CardsImpl pileToExile = new CardsImpl();
                pileToExile.addAllCards(choice ? pile2 : pile1);
                controller.moveCardsToExile(pileToExile.getCards(game), source, game, true, null, "");
                CardsImpl chosenPile = new CardsImpl();
                chosenPile.addAllCards(choice ? pile1 : pile2);
                TargetCard target2 = new TargetCard(Zone.HAND, new FilterCard("card to put into your hand"));
                if (controller.choose(this.outcome, (Cards)chosenPile, target2, source, game) && (card = chosenPile.get(target2.getFirstTarget(), game)) != null) {
                    controller.moveCards(card, Zone.HAND, source, game);
                }
                controller.shuffleLibrary(source, game);
            }
            return true;
        }
        return false;
    }
}

