/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.ShadowAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.util.CardUtil;

class PhyrexianSplicerChooseCost
extends CostImpl {
    private static final Map<String, Ability> allChoices = new LinkedHashMap<String, Ability>();
    Ability targetedAbility = null;

    public PhyrexianSplicerChooseCost() {
        this.text = "Choose flying, first strike, trample, or shadow";
    }

    private PhyrexianSplicerChooseCost(PhyrexianSplicerChooseCost cost) {
        super((CostImpl)cost);
        this.targetedAbility = cost.targetedAbility == null ? null : cost.targetedAbility.copy();
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Ability chosenAbility;
        this.paid = false;
        this.targetedAbility = null;
        Permanent losePermanent = game.getPermanent(((Target)source.getTargets().get(0)).getFirstTarget());
        Permanent gainPermanent = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        if (losePermanent == null || gainPermanent == null || controller == null) {
            return false;
        }
        Set choices = allChoices.entrySet().stream().filter(entry -> losePermanent.hasAbility((Ability)entry.getValue(), game)).map(Map.Entry::getKey).collect(Collectors.toCollection(LinkedHashSet::new));
        if (choices.size() == 1) {
            chosenAbility = allChoices.getOrDefault(choices.stream().findFirst().orElse(null), null);
        } else {
            ChoiceImpl choice = new ChoiceImpl(true);
            choice.setMessage("Choose ability to remove from " + losePermanent.getLogName() + " to " + gainPermanent.getLogName());
            choice.setChoices(choices);
            controller.choose(Outcome.LoseAbility, (Choice)choice, game);
            chosenAbility = allChoices.getOrDefault(choice.getChoice(), null);
        }
        if (chosenAbility == null) {
            return false;
        }
        this.targetedAbility = chosenAbility;
        this.paid = true;
        game.informPlayers(controller.getLogName() + " chosen ability to lose and gain: " + CardUtil.getTextWithFirstCharUpperCase((String)chosenAbility.getRule()));
        return true;
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return true;
    }

    public PhyrexianSplicerChooseCost copy() {
        return new PhyrexianSplicerChooseCost(this);
    }

    Ability getTargetedAbility() {
        return this.targetedAbility;
    }

    static {
        allChoices.put("Flying", (Ability)FlyingAbility.getInstance());
        allChoices.put("First Strike", (Ability)FirstStrikeAbility.getInstance());
        allChoices.put("Trample", (Ability)TrampleAbility.getInstance());
        allChoices.put("Shadow", (Ability)ShadowAbility.getInstance());
    }
}

