/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.p.PiasRevolutionReturnEffect;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.common.FilterArtifactPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

class PiasRevolutionTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterArtifactPermanent filter = new FilterArtifactPermanent();

    public PiasRevolutionTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new PiasRevolutionReturnEffect(), false);
        this.setTriggerPhrase("Whenever a nontoken artifact is put into your graveyard from the battlefield, ");
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private PiasRevolutionTriggeredAbility(PiasRevolutionTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public PiasRevolutionTriggeredAbility copy() {
        return new PiasRevolutionTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.isDiesEvent() && (permanent = (Permanent)game.getLastKnownInformation(event.getTargetId(), Zone.BATTLEFIELD)) != null && filter.match(permanent, this.controllerId, (Ability)this, game)) {
            for (Effect effect : this.getEffects()) {
                effect.setValue("permanentId", (Object)event.getTargetId());
            }
            return true;
        }
        return false;
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }

    static {
        filter.add((Predicate)TokenPredicate.FALSE);
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getOwnerPredicate());
    }
}

