/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class PillarTombsOfAkuEffect
extends OneShotEffect {
    PillarTombsOfAkuEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player may sacrifice a creature. If that player doesn't, they lose 5 life and you sacrifice {this}";
    }

    private PillarTombsOfAkuEffect(PillarTombsOfAkuEffect effect) {
        super((OneShotEffect)effect);
    }

    public PillarTombsOfAkuEffect copy() {
        return new PillarTombsOfAkuEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        SacrificeTargetCost cost;
        Player activePlayer = game.getPlayer(game.getActivePlayerId());
        if (activePlayer == null) {
            return false;
        }
        if (activePlayer.chooseUse(Outcome.Sacrifice, "Sacrifice a creature?", source, game) && (cost = new SacrificeTargetCost((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE)).canPay(source, source, activePlayer.getId(), game) && cost.pay(source, game, source, activePlayer.getId(), true)) {
            return true;
        }
        activePlayer.loseLife(5, game, source, false);
        return new SacrificeSourceEffect().apply(game, source);
    }
}

