/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PiousKitsuneEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("creature named Eight-and-a-Half-Tails");

    public PiousKitsuneEffect() {
        super(Outcome.Benefit);
        this.staticText = "put a devotion counter on {this}. Then if a creature named Eight-and-a-Half-Tails is on the battlefield, you gain 1 life for each devotion counter on {this}";
    }

    private PiousKitsuneEffect(PiousKitsuneEffect effect) {
        super((OneShotEffect)effect);
    }

    public PiousKitsuneEffect copy() {
        return new PiousKitsuneEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller;
        int life;
        Permanent permanent;
        boolean result = new AddCountersSourceEffect(CounterType.DEVOTION.createInstance()).apply(game, source);
        if (game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game) > 0 && (permanent = game.getPermanent(source.getSourceId())) != null && (life = permanent.getCounters(game).getCount(CounterType.DEVOTION)) > 0 && (controller = game.getPlayer(source.getControllerId())) != null) {
            controller.gainLife(life, game, source);
        }
        return result;
    }

    static {
        filter.add((Predicate)new NamePredicate("Eight-and-a-Half-Tails"));
    }
}

