/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.hint.Hint;
import mage.cards.p.PitOfOfferingsManaEffect;
import mage.game.Game;

enum PitOfOfferingsHint implements Hint
{
    instance;


    public String getText(Game game, Ability ability) {
        MageObject sourceObject = ability.getSourceObject(game);
        if (sourceObject == null) {
            return "";
        }
        Set<ObjectColor> exiledCardsColors = PitOfOfferingsManaEffect.getColorsExiled(sourceObject, game);
        ArrayList<String> manaText = new ArrayList<String>();
        if (exiledCardsColors.stream().anyMatch(ObjectColor::isWhite)) {
            manaText.add("{W}");
        }
        if (exiledCardsColors.stream().anyMatch(ObjectColor::isBlue)) {
            manaText.add("{U}");
        }
        if (exiledCardsColors.stream().anyMatch(ObjectColor::isBlack)) {
            manaText.add("{B}");
        }
        if (exiledCardsColors.stream().anyMatch(ObjectColor::isRed)) {
            manaText.add("{R}");
        }
        if (exiledCardsColors.stream().anyMatch(ObjectColor::isGreen)) {
            manaText.add("{G}");
        }
        if (manaText.isEmpty()) {
            return "";
        }
        return "Color of cards exiled: " + manaText.stream().collect(Collectors.joining(", "));
    }

    public PitOfOfferingsHint copy() {
        return this;
    }
}

