/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.Mana;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.cards.p.PitOfOfferingsEffect;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PitOfOfferingsManaEffect
extends ManaEffect {
    static Set<ObjectColor> getColorsExiled(MageObject sourceObject, Game game) {
        if (game == null) {
            return new HashSet<ObjectColor>();
        }
        ExileZone exileZone = game.getExile().getExileZone(PitOfOfferingsEffect.getExileZoneId(sourceObject, game));
        if (exileZone == null) {
            return new HashSet<ObjectColor>();
        }
        return exileZone.getCards(game).stream().map(c -> c.getColor(game)).collect(Collectors.toSet());
    }

    PitOfOfferingsManaEffect() {
        this.staticText = "Add one mana of any of the exiled cards' colors";
    }

    private PitOfOfferingsManaEffect(PitOfOfferingsManaEffect effect) {
        super((ManaEffect)effect);
    }

    public PitOfOfferingsManaEffect copy() {
        return new PitOfOfferingsManaEffect(this);
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        ArrayList<Mana> netMana = new ArrayList<Mana>();
        if (game == null) {
            return netMana;
        }
        MageObject sourceObject = source.getSourceObject(game);
        Set<ObjectColor> exiledCardsColors = PitOfOfferingsManaEffect.getColorsExiled(sourceObject, game);
        if (exiledCardsColors.stream().anyMatch(ObjectColor::isBlack)) {
            netMana.add(Mana.BlackMana((int)1));
        }
        if (exiledCardsColors.stream().anyMatch(ObjectColor::isRed)) {
            netMana.add(Mana.RedMana((int)1));
        }
        if (exiledCardsColors.stream().anyMatch(ObjectColor::isBlue)) {
            netMana.add(Mana.BlueMana((int)1));
        }
        if (exiledCardsColors.stream().anyMatch(ObjectColor::isGreen)) {
            netMana.add(Mana.GreenMana((int)1));
        }
        if (exiledCardsColors.stream().anyMatch(ObjectColor::isWhite)) {
            netMana.add(Mana.WhiteMana((int)1));
        }
        return netMana;
    }

    public Mana produceMana(Game game, Ability source) {
        Mana mana = new Mana();
        if (game == null) {
            return mana;
        }
        Permanent permanent = game.getPermanent(source.getSourceId());
        Player player = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (permanent == null || player == null || sourceObject == null) {
            return mana;
        }
        Set<ObjectColor> exiledCardsColors = PitOfOfferingsManaEffect.getColorsExiled(sourceObject, game);
        if (!exiledCardsColors.isEmpty()) {
            ChoiceColor choice = new ChoiceColor(true);
            choice.getChoices().clear();
            choice.setMessage("Pick a mana color");
            if (exiledCardsColors.stream().anyMatch(ObjectColor::isBlack)) {
                choice.getChoices().add("Black");
            }
            if (exiledCardsColors.stream().anyMatch(ObjectColor::isRed)) {
                choice.getChoices().add("Red");
            }
            if (exiledCardsColors.stream().anyMatch(ObjectColor::isBlue)) {
                choice.getChoices().add("Blue");
            }
            if (exiledCardsColors.stream().anyMatch(ObjectColor::isGreen)) {
                choice.getChoices().add("Green");
            }
            if (exiledCardsColors.stream().anyMatch(ObjectColor::isWhite)) {
                choice.getChoices().add("White");
            }
            if (!choice.getChoices().isEmpty()) {
                if (choice.getChoices().size() == 1) {
                    choice.setChoice((String)choice.getChoices().iterator().next());
                } else if (!player.choose(Outcome.PutManaInPool, (Choice)choice, game)) {
                    return mana;
                }
                switch (choice.getChoice()) {
                    case "Black": {
                        mana.add(Mana.BlackMana((int)1));
                        break;
                    }
                    case "Blue": {
                        mana.add(Mana.BlueMana((int)1));
                        break;
                    }
                    case "Red": {
                        mana.add(Mana.RedMana((int)1));
                        break;
                    }
                    case "Green": {
                        mana.add(Mana.GreenMana((int)1));
                        break;
                    }
                    case "White": {
                        mana.add(Mana.WhiteMana((int)1));
                        break;
                    }
                }
            }
        }
        return mana;
    }
}

