/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class PlagiarizeEffect
extends ReplacementEffectImpl {
    public PlagiarizeEffect() {
        super(Duration.EndOfTurn, Outcome.Detriment);
        this.staticText = "Until end of turn, if target player would draw a card, instead that player skips that draw and you draw a card";
    }

    private PlagiarizeEffect(PlagiarizeEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public PlagiarizeEffect copy() {
        return new PlagiarizeEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            player.drawCards(1, source, game, event);
        }
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getPlayerId().equals(source.getFirstTarget());
    }
}

