/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class PlagueReaverReturnEffect
extends OneShotEffect {
    private final UUID playerId;

    PlagueReaverReturnEffect(UUID playerId) {
        super(Outcome.Benefit);
        this.playerId = playerId;
    }

    private PlagueReaverReturnEffect(PlagueReaverReturnEffect effect) {
        super((OneShotEffect)effect);
        this.playerId = effect.playerId;
    }

    public PlagueReaverReturnEffect copy() {
        return new PlagueReaverReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.playerId);
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        return player != null && card != null && player.moveCards(card, Zone.BATTLEFIELD, source, game);
    }
}

