/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class PlanarBirthEffect
extends OneShotEffect {
    PlanarBirthEffect() {
        super(Outcome.PutLandInPlay);
        this.staticText = "Return all basic land cards from all graveyards to the battlefield tapped under their owners' control";
    }

    private PlanarBirthEffect(PlanarBirthEffect effect) {
        super((OneShotEffect)effect);
    }

    public PlanarBirthEffect copy() {
        return new PlanarBirthEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CardsImpl toBattlefield = new CardsImpl();
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                toBattlefield.addAllCards((Collection)player.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND, controller.getId(), source, game));
            }
            controller.moveCards(toBattlefield.getCards(game), Zone.BATTLEFIELD, source, game, true, false, true, null);
            return true;
        }
        return false;
    }
}

