/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.HashSet;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.p.PlanarGuideReturnFromExileEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;

class PlanarGuideExileEffect
extends OneShotEffect {
    PlanarGuideExileEffect() {
        super(Outcome.Detriment);
        this.staticText = "Exile all creatures. At the beginning of the next end step, return those cards to the battlefield under their owners' control";
    }

    private PlanarGuideExileEffect(PlanarGuideExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        MageObject sourceObject = game.getObject(source);
        Player controller = game.getPlayer(source.getControllerId());
        if (sourceObject != null && controller != null) {
            HashSet toExile = new HashSet();
            toExile.addAll(game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game));
            controller.moveCardsToExile(toExile, source, game, true, source.getSourceId(), sourceObject.getIdName());
            ExileZone exile = game.getExile().getExileZone(source.getSourceId());
            if (exile != null && !exile.isEmpty()) {
                AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new PlanarGuideReturnFromExileEffect());
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
                return true;
            }
            return true;
        }
        return false;
    }

    public PlanarGuideExileEffect copy() {
        return new PlanarGuideExileEffect(this);
    }
}

