/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class PlanarOverlayEffect
extends OneShotEffect {
    PlanarOverlayEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Each player chooses a land they control of each basic land type. Return those lands to their owners' hands";
    }

    private PlanarOverlayEffect(PlanarOverlayEffect effect) {
        super((OneShotEffect)effect);
    }

    public PlanarOverlayEffect copy() {
        return new PlanarOverlayEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            HashSet<Permanent> lands = new HashSet<Permanent>();
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                for (SubType landName : SubType.getBasicLands()) {
                    FilterLandPermanent filter = new FilterLandPermanent(landName + " to return to hand");
                    filter.add((Predicate)landName.getPredicate());
                    filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
                    TargetPermanent target = new TargetPermanent(1, 1, (FilterPermanent)filter, true);
                    if (!target.canChoose(player.getId(), source, game)) continue;
                    player.chooseTarget(this.outcome, (Target)target, source, game);
                    lands.add(game.getPermanent(target.getFirstTarget()));
                }
            }
            controller.moveCards(lands, Zone.HAND, source, game);
            return true;
        }
        return false;
    }
}

