/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class PlaneswalkersMischiefCastFromExileEffect
extends AsThoughEffectImpl {
    PlaneswalkersMischiefCastFromExileEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.Custom, Outcome.Benefit);
        this.staticText = "You may cast that card without paying its mana cost as long as it remains exiled";
    }

    private PlaneswalkersMischiefCastFromExileEffect(PlaneswalkersMischiefCastFromExileEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public PlaneswalkersMischiefCastFromExileEffect copy() {
        return new PlaneswalkersMischiefCastFromExileEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (this.getTargetPointer().getTargets(game, source).contains(objectId) && game.getState().getZone(objectId) == Zone.EXILED) {
            Player player = game.getPlayer(source.getControllerId());
            Card card = game.getCard(objectId);
            if (player != null && card != null) {
                return this.allowCardToPlayWithoutMana(objectId, source, affectedControllerId, game);
            }
        }
        return false;
    }
}

