/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class PlungeIntoDarknessLifeEffect
extends OneShotEffect {
    PlungeIntoDarknessLifeEffect() {
        super(Outcome.GainLife);
        this.staticText = "Sacrifice any number of creatures, then you gain 3 life for each sacrificed creature";
    }

    private PlungeIntoDarknessLifeEffect(PlungeIntoDarknessLifeEffect effect) {
        super((OneShotEffect)effect);
    }

    public PlungeIntoDarknessLifeEffect copy() {
        return new PlungeIntoDarknessLifeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            TargetSacrifice target = new TargetSacrifice(0, Integer.MAX_VALUE, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE);
            player.choose(Outcome.Sacrifice, (Target)target, source, game);
            int numSacrificed = 0;
            for (UUID permanentId : target.getTargets()) {
                Permanent permanent = game.getPermanent(permanentId);
                if (permanent == null || !permanent.sacrifice(source, game)) continue;
                ++numSacrificed;
            }
            if (numSacrificed > 0) {
                player.gainLife(3 * numSacrificed, game, source);
            }
            return true;
        }
        return false;
    }
}

