/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PoisonControllerTargetCreatureEffect
extends OneShotEffect {
    PoisonControllerTargetCreatureEffect() {
        super(Outcome.Damage);
        this.staticText = "Its controller gets a poison counter";
    }

    private PoisonControllerTargetCreatureEffect(PoisonControllerTargetCreatureEffect effect) {
        super((OneShotEffect)effect);
    }

    public PoisonControllerTargetCreatureEffect copy() {
        return new PoisonControllerTargetCreatureEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (permanent != null) {
            Player player = game.getPlayer(permanent.getControllerId());
            if (player != null) {
                player.addCounters(CounterType.POISON.createInstance(), source.getControllerId(), source, game);
            }
            return true;
        }
        return false;
    }
}

