/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.p.PollenbrightWingsEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class PollenbrightWingsAbility
extends TriggeredAbilityImpl {
    public PollenbrightWingsAbility() {
        super(Zone.BATTLEFIELD, (Effect)new PollenbrightWingsEffect());
    }

    private PollenbrightWingsAbility(PollenbrightWingsAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public PollenbrightWingsAbility copy() {
        return new PollenbrightWingsAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        DamagedPlayerEvent damageEvent = (DamagedPlayerEvent)event;
        Permanent damageSource = game.getPermanent(event.getSourceId());
        if (damageEvent.isCombatDamage() && damageSource != null && damageSource.getAttachments().contains(this.getSourceId())) {
            game.getState().setValue("Damage_" + this.getSourceId(), (Object)damageEvent.getAmount());
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever enchanted creature deals combat damage to a player, create that many 1/1 green Saproling creature tokens.";
    }
}

