/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class PolymorphousRushCopyEffect
extends OneShotEffect {
    PolymorphousRushCopyEffect() {
        super(Outcome.Copy);
        this.staticText = "Choose a creature on the battlefield. Any number of target creatures you control each become a copy of that creature until end of turn";
    }

    private PolymorphousRushCopyEffect(PolymorphousRushCopyEffect effect) {
        super((OneShotEffect)effect);
    }

    public PolymorphousRushCopyEffect copy() {
        return new PolymorphousRushCopyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent copyFromCreature;
            TargetPermanent target = new TargetPermanent((FilterPermanent)new FilterCreaturePermanent(""));
            target.withNotTarget(true);
            target.withTargetName("a creature on the battlefield (creature to copy)");
            if (target.canChoose(controller.getId(), source, game) && controller.chooseTarget(this.outcome, (Target)target, source, game) && (copyFromCreature = game.getPermanent(target.getFirstTarget())) != null) {
                for (UUID copyToId : this.getTargetPointer().getTargets(game, source)) {
                    Permanent copyToCreature = game.getPermanent(copyToId);
                    if (copyToCreature == null) continue;
                    game.copyPermanent(Duration.EndOfTurn, copyFromCreature, copyToId, source, (CopyApplier)new EmptyCopyApplier());
                }
            }
            return true;
        }
        return false;
    }
}

