/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.permanent.ProtectedByOpponentPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class PortentTrackerEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent();

    PortentTrackerEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose target battle. If an opponent protects it, remove a defense counter from it. Otherwise, put a defense counter on it";
    }

    private PortentTrackerEffect(PortentTrackerEffect effect) {
        super((OneShotEffect)effect);
    }

    public PortentTrackerEffect copy() {
        return new PortentTrackerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        if (!filter.match(permanent, source.getControllerId(), source, game)) {
            return permanent.addCounters(CounterType.DEFENSE.createInstance(), source, game);
        }
        permanent.removeCounters(CounterType.DEFENSE.createInstance(), source, game);
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)ProtectedByOpponentPredicate.instance);
    }
}

