/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInYourGraveyard;

class PotholeMoleEffect
extends OneShotEffect {
    PotholeMoleEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then you may return a land card from your graveyard to your hand";
    }

    private PotholeMoleEffect(PotholeMoleEffect effect) {
        super((OneShotEffect)effect);
    }

    public PotholeMoleEffect copy() {
        return new PotholeMoleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(0, 1, (FilterCard)StaticFilters.FILTER_CARD_LAND, true);
        player.choose(this.outcome, (Cards)player.getGraveyard(), (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        return card != null && player.moveCards(card, Zone.HAND, source, game);
    }
}

