/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.constants.WatcherScope;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledLandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class PowerSurgeWatcher
extends Watcher {
    private static final FilterPermanent filter = new FilterControlledLandPermanent();
    private int untappedLandCount;

    public PowerSurgeWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.BEGINNING_PHASE_PRE && game.getPhase() != null) {
            this.untappedLandCount = game.getBattlefield().countAll(filter, game.getActivePlayerId(), game);
        }
    }

    public int getUntappedLandCount() {
        return this.untappedLandCount;
    }

    public void reset() {
        this.untappedLandCount = 0;
    }

    static {
        filter.add((Predicate)TappedPredicate.UNTAPPED);
    }
}

