/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackAbility;
import mage.players.Player;

class PowerleechTriggeredAbility
extends TriggeredAbilityImpl {
    PowerleechTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new GainLifeEffect(1));
    }

    private PowerleechTriggeredAbility(PowerleechTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public PowerleechTriggeredAbility copy() {
        return new PowerleechTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATED_ABILITY || event.getType() == GameEvent.EventType.TAPPED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Player player = game.getPlayer(this.controllerId);
        if (player == null) {
            return false;
        }
        if (event.getType() == GameEvent.EventType.ACTIVATED_ABILITY) {
            Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
            if (permanent == null || !permanent.isArtifact(game)) {
                return false;
            }
            StackAbility stackAbility = (StackAbility)game.getStack().getStackObject(event.getSourceId());
            if (stackAbility == null) {
                return false;
            }
            return !stackAbility.hasTapCost() && player.hasOpponent(permanent.getControllerId(), game);
        }
        if (event.getType() == GameEvent.EventType.TAPPED) {
            Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
            if (permanent == null || !permanent.isArtifact(game)) {
                return false;
            }
            return player.hasOpponent(permanent.getControllerId(), game);
        }
        return false;
    }

    public String getRule() {
        return "Whenever an artifact an opponent controls becomes tapped or an opponent activates an artifact's ability without {T} in its activation cost, you gain 1 life.";
    }
}

