/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.AttachEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class PreWarFormalwerEffect
extends OneShotEffect {
    PreWarFormalwerEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "return target creature card with mana value 3 or less from your graveyard to the battlefield and attach {this} to it";
    }

    private PreWarFormalwerEffect(PreWarFormalwerEffect effect) {
        super((OneShotEffect)effect);
    }

    public PreWarFormalwerEffect copy() {
        return new PreWarFormalwerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(source.getFirstTarget());
        Player player = game.getPlayer(source.getControllerId());
        if (card == null || player == null) {
            return false;
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent != null) {
            new AttachEffect(Outcome.BoostCreature).setTargetPointer((TargetPointer)new FixedTarget(permanent.getId())).apply(game, source);
        }
        return true;
    }
}

