/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.common.CopySpellForEachItCouldTargetEffect;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.mageobject.MageObjectReferencePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;

class PrecursorGolemCopySpellEffect
extends CopySpellForEachItCouldTargetEffect {
    private static final FilterPermanent filter = new FilterPermanent(SubType.GOLEM, "");

    PrecursorGolemCopySpellEffect() {
    }

    private PrecursorGolemCopySpellEffect(PrecursorGolemCopySpellEffect effect) {
        super((CopySpellForEachItCouldTargetEffect)effect);
    }

    protected Player getPlayer(Game game, Ability source) {
        Spell spell = this.getStackObject(game, source);
        if (spell == null) {
            return null;
        }
        return game.getPlayer(spell.getControllerId());
    }

    protected List<MageObjectReferencePredicate> prepareCopiesWithTargets(StackObject stackObject, Player player, Ability source, Game game) {
        Permanent permanent = game.getPermanent((UUID)this.getValue("targetedGolem"));
        return game.getBattlefield().getActivePermanents(filter, player.getId(), source, game).stream().filter(Objects::nonNull).filter(p -> !p.equals(permanent)).filter(p -> stackObject.canTarget(game, p.getId())).map(p -> new MageObjectReference((MageObject)p, game)).map(MageObjectReferencePredicate::new).collect(Collectors.toList());
    }

    protected Spell getStackObject(Game game, Ability source) {
        return (Spell)this.getValue("triggeringSpell");
    }

    public PrecursorGolemCopySpellEffect copy() {
        return new PrecursorGolemCopySpellEffect(this);
    }
}

