/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class PredatoryFocusEffect
extends AsThoughEffectImpl {
    private boolean choseUse;

    public PredatoryFocusEffect() {
        super(AsThoughEffectType.DAMAGE_NOT_BLOCKED, Duration.EndOfTurn, Outcome.Damage);
        this.staticText = "You may have creatures you control assign their combat damage this turn as though they weren't blocked.";
    }

    private PredatoryFocusEffect(PredatoryFocusEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        Player controller = game.getPlayer(source.getControllerId());
        String sourceName = source.getSourceObject(game).getLogName();
        this.choseUse = controller.chooseUse(Outcome.Damage, "Have creatures you control deal combat damage this turn as though they weren't blocked?", source, game);
        game.informPlayers(this.choseUse ? controller.getName() + " chose to use " + sourceName + "'s effect" : controller.getName() + " chose not to use " + sourceName + "'s effect.");
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        return this.choseUse && affectedControllerId.equals(source.getControllerId());
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public PredatoryFocusEffect copy() {
        return new PredatoryFocusEffect(this);
    }
}

