/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.costs.CompositeCost;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.abilities.effects.common.LookLibraryAndPickControllerEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.PutCards;
import mage.game.Game;
import mage.players.Player;

class PreferredSelectionEffect
extends OneShotEffect {
    PreferredSelectionEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top two cards of your library. You may sacrifice {this} and pay {2}{G}{G}. If you do, put one of those cards into your hand. If you don't, put one of those cards on the bottom of your library.";
    }

    private PreferredSelectionEffect(PreferredSelectionEffect effect) {
        super((OneShotEffect)effect);
    }

    public PreferredSelectionEffect copy() {
        return new PreferredSelectionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 2));
        player.lookAtCards(source, "Top two cards", (Cards)cards, game);
        CompositeCost cost = new CompositeCost((Cost)new SacrificeSourceCost(), (Cost)new ManaCostsImpl("{2}{G}{G}"), "sacrifice this permanent and pay {2}{G}{G}");
        return new DoIfCostPaid((Effect)new LookLibraryAndPickControllerEffect(2, 1, PutCards.HAND, PutCards.TOP_ANY), (Effect)new LookLibraryAndPickControllerEffect(2, 1, PutCards.BOTTOM_ANY, PutCards.TOP_ANY), (Cost)cost).apply(game, source);
    }
}

