/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.p.CounterEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PresenceOfTheMasterTriggeredAbility
extends TriggeredAbilityImpl {
    public PresenceOfTheMasterTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CounterEffect());
    }

    private PresenceOfTheMasterTriggeredAbility(PresenceOfTheMasterTriggeredAbility abiltity) {
        super((TriggeredAbilityImpl)abiltity);
    }

    public PresenceOfTheMasterTriggeredAbility copy() {
        return new PresenceOfTheMasterTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell = game.getStack().getSpell(event.getTargetId());
        if (spell != null && spell.isEnchantment(game)) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId()));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a player casts an enchantment spell, counter it.";
    }
}

