/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterInstantOrSorceryCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.util.CardUtil;

class PressTheEnemyEffect
extends OneShotEffect {
    PressTheEnemyEffect() {
        super(Outcome.Benefit);
        this.staticText = "return target spell or nonland permanent an opponent controls to its owner's hand. You may cast an instant or sorcery spell with equal or lesser mana value from your hand without paying its mana cost";
    }

    private PressTheEnemyEffect(PressTheEnemyEffect effect) {
        super((OneShotEffect)effect);
    }

    public PressTheEnemyEffect copy() {
        return new PressTheEnemyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int mv;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        UUID targetId = this.getTargetPointer().getFirst(game, source);
        Spell spell = game.getSpell(targetId);
        if (spell == null) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null) {
                return false;
            }
            mv = permanent.getManaValue();
            player.moveCards((Card)permanent, Zone.HAND, source, game);
        } else {
            mv = spell.getManaValue();
            player.moveCards((Card)spell, Zone.HAND, source, game);
        }
        FilterInstantOrSorceryCard filter = new FilterInstantOrSorceryCard();
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, mv + 1));
        CardUtil.castSpellWithAttributesForFree((Player)player, (Ability)source, (Game)game, (Cards)new CardsImpl((Collection)player.getHand()), (FilterCard)filter);
        return true;
    }
}

