/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class PresumedDeadEffect
extends OneShotEffect {
    PresumedDeadEffect() {
        super(Outcome.Benefit);
        this.staticText = "return it to the battlefield under its owner's control and suspect it";
    }

    private PresumedDeadEffect(PresumedDeadEffect effect) {
        super((OneShotEffect)effect);
    }

    public PresumedDeadEffect copy() {
        return new PresumedDeadEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getSourceId());
        if (controller == null || card == null) {
            return false;
        }
        controller.moveCards(card, Zone.BATTLEFIELD, source, game, false, false, true, null);
        game.processAction();
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent != null) {
            permanent.setSuspected(true, game, source);
        }
        return true;
    }
}

