/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.watchers.common.ManaPaidSourceWatcher;

class PriceOfLoyaltyEffect
extends OneShotEffect {
    PriceOfLoyaltyEffect() {
        super(Outcome.Benefit);
        this.staticText = "If mana from a Treasure was spent to cast this spell, that creature gets +2/+0 until end of turn";
    }

    private PriceOfLoyaltyEffect(PriceOfLoyaltyEffect effect) {
        super((OneShotEffect)effect);
    }

    public PriceOfLoyaltyEffect copy() {
        return new PriceOfLoyaltyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (ManaPaidSourceWatcher.getTreasurePaid((UUID)source.getId(), (Game)game) > 0) {
            game.addEffect((ContinuousEffect)new BoostTargetEffect(2, 0), source);
            return true;
        }
        return false;
    }
}

