/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureTargetEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.cards.p.PrimalAdversaryToken;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.target.Target;
import mage.target.TargetPermanent;

class PrimalAdversaryEffect
extends OneShotEffect {
    PrimalAdversaryEffect() {
        super(Outcome.Benefit);
        this.staticText = "put that many +1/+1 counters on {this}, then up to that many target lands you control become 3/3 Wolf creatures with haste that are still lands";
    }

    private PrimalAdversaryEffect(PrimalAdversaryEffect effect) {
        super((OneShotEffect)effect);
    }

    public PrimalAdversaryEffect copy() {
        return new PrimalAdversaryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Integer timesPaid = (Integer)this.getValue("timesPaid");
        if (timesPaid == null || timesPaid <= 0) {
            return false;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance(timesPaid.intValue())), false, this.staticText);
        ability.addEffect((Effect)new BecomesCreatureTargetEffect((Token)new PrimalAdversaryToken(), false, true, Duration.Custom));
        ability.addTarget((Target)new TargetPermanent(0, timesPaid.intValue(), (FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LANDS));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

