/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessSourceEffect;
import mage.abilities.keyword.DefenderAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

public final class PrimalClay
extends CardImpl {
    public PrimalClay(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT, CardType.CREATURE}, "{4}");
        this.subtype.add((Object)SubType.SHAPESHIFTER);
        this.power = new MageInt(0);
        this.toughness = new MageInt(0);
        this.addAbility((Ability)new SimpleStaticAbility(Zone.ALL, (Effect)new PrimalPlasmaReplacementEffect()));
    }

    private PrimalClay(PrimalClay card) {
        super((CardImpl)card);
    }

    public PrimalClay copy() {
        return new PrimalClay(this);
    }

    static class PrimalPlasmaReplacementEffect
    extends ReplacementEffectImpl {
        private static final String choice33 = "a 3/3 artifact creature";
        private static final String choice22 = "a 2/2 artifact creature with flying";
        private static final String choice16 = "a 1/6 artifact creature with defender";

        public PrimalPlasmaReplacementEffect() {
            super(Duration.WhileOnBattlefield, Outcome.Benefit);
            this.staticText = "As {this} enters, it becomes your choice of a 3/3 artifact creature, a 2/2 artifact creature with flying, or a 1/6 Wall artifact creature with defender in addition to its other types";
        }

        private PrimalPlasmaReplacementEffect(PrimalPlasmaReplacementEffect effect) {
            super((ReplacementEffectImpl)effect);
        }

        public boolean checksEventType(GameEvent event, Game game) {
            return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
        }

        public boolean applies(GameEvent event, Ability source, Game game) {
            if (!event.getTargetId().equals(source.getSourceId())) {
                return false;
            }
            Permanent sourcePermanent = ((EntersTheBattlefieldEvent)event).getTarget();
            return sourcePermanent != null && !sourcePermanent.isFaceDown(game);
        }

        public boolean replaceEvent(GameEvent event, Ability source, Game game) {
            Permanent permanent = ((EntersTheBattlefieldEvent)event).getTarget();
            if (permanent == null) {
                return false;
            }
            ChoiceImpl choice = new ChoiceImpl(true);
            choice.setMessage("Choose what " + permanent.getIdName() + " becomes to");
            choice.getChoices().add(choice33);
            choice.getChoices().add(choice22);
            choice.getChoices().add(choice16);
            Player controller = game.getPlayer(source.getControllerId());
            if (controller != null && !controller.choose(Outcome.Neutral, (Choice)choice, game)) {
                return false;
            }
            int power = 0;
            int toughness = 0;
            switch (choice.getChoice()) {
                case "a 3/3 artifact creature": {
                    power = 3;
                    toughness = 3;
                    break;
                }
                case "a 2/2 artifact creature with flying": {
                    power = 2;
                    toughness = 2;
                    game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)FlyingAbility.getInstance(), Duration.Custom), source);
                    break;
                }
                case "a 1/6 artifact creature with defender": {
                    power = 1;
                    toughness = 6;
                    game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)DefenderAbility.getInstance(), Duration.Custom), source);
                }
            }
            game.addEffect((ContinuousEffect)new SetBasePowerToughnessSourceEffect(power, toughness, Duration.WhileOnBattlefield), source);
            return false;
        }

        public PrimalPlasmaReplacementEffect copy() {
            return new PrimalPlasmaReplacementEffect(this);
        }
    }
}

