/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.players.Player;

class PrimevalSpawnReplacementEffect
extends ReplacementEffectImpl {
    PrimevalSpawnReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Exile);
        this.staticText = "if {this} would enter the battlefield and it wasn't cast or no mana was spent to cast it, exile it instead";
    }

    private PrimevalSpawnReplacementEffect(PrimevalSpawnReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public PrimevalSpawnReplacementEffect copy() {
        return new PrimevalSpawnReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = game.getCard(event.getTargetId());
        if (card != null) {
            controller.moveCards(card, Zone.EXILED, source, game);
        }
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!source.getSourceId().equals(event.getTargetId())) {
            return false;
        }
        if (((EntersTheBattlefieldEvent)event).getFromZone() != Zone.STACK) {
            return true;
        }
        Spell spell = game.getSpell(event.getTargetId());
        return spell != null && spell.getStackAbility().getManaCostsToPay().getUsedManaToPay().count() < 1;
    }
}

