/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PrinceOfThrallsEffect
extends OneShotEffect {
    PrinceOfThrallsEffect() {
        super(Outcome.Neutral);
        this.staticText = "put that card onto the battlefield under your control unless that opponent pays 3 life";
    }

    private PrinceOfThrallsEffect(PrinceOfThrallsEffect effect) {
        super((OneShotEffect)effect);
    }

    public PrinceOfThrallsEffect copy() {
        return new PrinceOfThrallsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        Permanent permanent = (Permanent)game.getLastKnownInformation(this.getTargetPointer().getFirst(game, source), Zone.BATTLEFIELD);
        if (controller != null && card != null && permanent != null) {
            Player opponent = game.getPlayer(permanent.getControllerId());
            if (opponent != null) {
                PayLifeCost cost = new PayLifeCost(3);
                if (opponent.chooseUse(Outcome.Neutral, cost.getText() + " or " + card.getLogName() + " comes back into the battlefield under opponents control", source, game)) {
                    cost.clearPaid();
                    if (cost.pay(source, game, source, opponent.getId(), true, null)) {
                        return true;
                    }
                }
                controller.moveCards(card, Zone.BATTLEFIELD, source, game);
            }
            return true;
        }
        return false;
    }
}

