/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileTopXMayPlayUntilEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class PriorityBoardingEffect
extends OneShotEffect {
    PriorityBoardingEffect() {
        super(Outcome.Benefit);
    }

    private PriorityBoardingEffect(PriorityBoardingEffect effect) {
        super((OneShotEffect)effect);
    }

    public PriorityBoardingEffect copy() {
        return new PriorityBoardingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.revealCards(source, (Cards)new CardsImpl(card), game);
        if (this.getValue("rolled") == null) {
            return true;
        }
        int amount = (Integer)this.getValue("rolled");
        if (amount > card.getManaValue()) {
            ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new ExileTopXMayPlayUntilEffect(1, Duration.EndOfTurn).withTextOptions("it", true), true);
            game.fireReflexiveTriggeredAbility(ability, source);
            return true;
        }
        return true;
    }
}

