/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.p.PrismaticStrandsPreventionEffect;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class PrismaticStrandsEffect
extends OneShotEffect {
    PrismaticStrandsEffect() {
        super(Outcome.PreventDamage);
        this.staticText = "Prevent all damage that sources of the color of your choice would deal this turn";
    }

    private PrismaticStrandsEffect(PrismaticStrandsEffect effect) {
        super((OneShotEffect)effect);
    }

    public PrismaticStrandsEffect copy() {
        return new PrismaticStrandsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller == null || sourceObject == null) {
            return false;
        }
        ChoiceColor choice = new ChoiceColor();
        controller.choose(Outcome.PreventDamage, (Choice)choice, game);
        if (!choice.isChosen()) {
            return false;
        }
        game.informPlayers(sourceObject.getLogName() + ": " + controller.getLogName() + " has chosen sources of the color " + choice.getChoice());
        game.addEffect((ContinuousEffect)new PrismaticStrandsPreventionEffect(choice.getColor()), source);
        return true;
    }
}

