/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;

class PrismaticStrandsPreventionEffect
extends PreventionEffectImpl {
    private final ObjectColor color;

    PrismaticStrandsPreventionEffect(ObjectColor color) {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, false, false);
        this.color = color;
    }

    private PrismaticStrandsPreventionEffect(PrismaticStrandsPreventionEffect effect) {
        super((PreventionEffectImpl)effect);
        this.color = effect.color;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!super.applies(event, source, game) || event.getType() != GameEvent.EventType.DAMAGE_PLAYER && event.getType() != GameEvent.EventType.DAMAGE_PERMANENT) {
            return false;
        }
        MageObject sourceObject = game.getObject(event.getSourceId());
        return sourceObject != null && sourceObject.getColor(game).shares(this.color);
    }

    public PrismaticStrandsPreventionEffect copy() {
        return new PrismaticStrandsPreventionEffect(this);
    }
}

