/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class PrismaticWardPreventDamageEffect
extends PreventionEffectImpl {
    PrismaticWardPreventDamageEffect() {
        super(Duration.WhileOnBattlefield, Integer.MAX_VALUE, false);
        this.staticText = "Prevent all damage that would be dealt to enchanted creature by sources of the chosen color.";
    }

    private PrismaticWardPreventDamageEffect(PrismaticWardPreventDamageEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public PrismaticWardPreventDamageEffect copy() {
        return new PrismaticWardPreventDamageEffect(this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!super.applies(event, source, game)) {
            return false;
        }
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            return false;
        }
        ObjectColor color = (ObjectColor)game.getState().getValue(permanent.getId() + "_color");
        if (color == null) {
            return false;
        }
        MageObject sourceObject = game.getObject(event.getSourceId());
        if (sourceObject == null || !sourceObject.getColor(game).shares(color)) {
            return false;
        }
        Permanent attachment = game.getPermanent(source.getSourceId());
        return attachment != null && attachment.getAttachedTo() != null && event.getTargetId().equals(attachment.getAttachedTo());
    }
}

