/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.abilities.effects.common.ChooseCreatureTypeEffect;
import mage.cards.Card;
import mage.cards.p.ProgenitorsIconWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;

class ProgenitorsIconAsThoughEffect
extends AsThoughEffectImpl {
    ProgenitorsIconAsThoughEffect() {
        super(AsThoughEffectType.CAST_AS_INSTANT, Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "The next spell of the chosen type you cast this turn can be cast as though it had flash";
    }

    private ProgenitorsIconAsThoughEffect(ProgenitorsIconAsThoughEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        SubType subType = ChooseCreatureTypeEffect.getChosenCreatureType((UUID)source.getSourceId(), (Game)game);
        ProgenitorsIconWatcher.addPlayer(source.getControllerId(), subType, game);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public ProgenitorsIconAsThoughEffect copy() {
        return new ProgenitorsIconAsThoughEffect(this);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        if (!source.isControlledBy(affectedControllerId)) {
            return false;
        }
        SubType subType = ChooseCreatureTypeEffect.getChosenCreatureType((UUID)source.getSourceId(), (Game)game);
        if (!ProgenitorsIconWatcher.checkPlayerCast(affectedControllerId, subType, game)) {
            this.discard();
            return false;
        }
        Card card = game.getCard(sourceId);
        if (card == null) {
            return false;
        }
        return card.hasSubtype(subType, game);
    }
}

