/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.condition.common.KickedCondition;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class ProhibitEffect
extends OneShotEffect {
    ProhibitEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Counter target spell if its mana value is 2 or less. If this spell was kicked, counter that spell if its mana value is 4 or less instead.";
    }

    private ProhibitEffect(ProhibitEffect effect) {
        super((OneShotEffect)effect);
    }

    public ProhibitEffect copy() {
        return new ProhibitEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int cmc;
            Spell targetSpell = game.getSpell(this.getTargetPointer().getFirst(game, source));
            if (targetSpell != null && ((cmc = targetSpell.getManaValue()) <= 2 || KickedCondition.ONCE.apply(game, source) && cmc <= 4)) {
                game.getStack().counter(targetSpell.getId(), source, game);
            }
            return true;
        }
        return false;
    }
}

