/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class PromiseOfLoyaltyAttackEffect
extends RestrictionEffect {
    PromiseOfLoyaltyAttackEffect() {
        super(Duration.Custom);
    }

    private PromiseOfLoyaltyAttackEffect(PromiseOfLoyaltyAttackEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        Permanent p = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (p == null || p.getCounters(game).getCount(CounterType.VOW) < 1) {
            this.discard();
            return false;
        }
        return permanent.getId().equals(p.getId());
    }

    public boolean canAttack(Permanent attacker, UUID defenderId, Ability source, Game game, boolean canUseChooseDialogs) {
        if (defenderId == null) {
            return true;
        }
        if (source.isControlledBy(defenderId)) {
            return false;
        }
        Permanent planeswalker = game.getPermanent(defenderId);
        return planeswalker == null || !planeswalker.isControlledBy(source.getControllerId());
    }

    public PromiseOfLoyaltyAttackEffect copy() {
        return new PromiseOfLoyaltyAttackEffect(this);
    }
}

