/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.util.functions.CopyTokenFunction;

class PrototypePortalCreateTokenEffect
extends OneShotEffect {
    PrototypePortalCreateTokenEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Create a token that's a copy of the exiled card. X is the mana value of that card";
    }

    private PrototypePortalCreateTokenEffect(PrototypePortalCreateTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public PrototypePortalCreateTokenEffect copy() {
        return new PrototypePortalCreateTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            return false;
        }
        if (!permanent.getImprinted().isEmpty() && (card = game.getCard((UUID)permanent.getImprinted().get(0))) != null) {
            Token token = CopyTokenFunction.createTokenCopy((Card)card, (Game)game);
            token.putOntoBattlefield(1, game, source, source.getControllerId());
            return true;
        }
        return false;
    }
}

