/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.players.Player;

class PsychicAllergyEffect
extends OneShotEffect {
    PsychicAllergyEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals X damage to that player, where X is the number of nontoken permanents of the chosen color they control";
    }

    private PsychicAllergyEffect(PsychicAllergyEffect copy) {
        super((OneShotEffect)copy);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null) {
            FilterPermanent filter = new FilterPermanent();
            filter.add((Predicate)new ColorPredicate((ObjectColor)game.getState().getValue(source.getSourceId() + "_color")));
            filter.add((Predicate)TokenPredicate.FALSE);
            int damage = game.getBattlefield().countAll(filter, player.getId(), game);
            player.damage(damage, source.getSourceId(), source, game);
            return true;
        }
        return false;
    }

    public PsychicAllergyEffect copy() {
        return new PsychicAllergyEffect(this);
    }
}

