/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.LoseLifeTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.StackObject;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PsychicPurgeTriggeredAbility
extends TriggeredAbilityImpl {
    public PsychicPurgeTriggeredAbility() {
        super(Zone.GRAVEYARD, (Effect)new LoseLifeTargetEffect(5), false);
    }

    private PsychicPurgeTriggeredAbility(PsychicPurgeTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public PsychicPurgeTriggeredAbility copy() {
        return new PsychicPurgeTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DISCARDED_CARD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        StackObject stackObject;
        if (this.getSourceId().equals(event.getTargetId()) && (stackObject = game.getStack().getStackObject(event.getSourceId())) != null && game.getOpponents(this.getControllerId()).contains(stackObject.getControllerId())) {
            Effect effect = (Effect)this.getEffects().get(0);
            effect.setTargetPointer((TargetPointer)new FixedTarget(stackObject.getControllerId()));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "When a spell or ability an opponent controls causes you to discard {this}, that player loses 5 life.";
    }
}

