/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class PsychicSpiralEffect
extends OneShotEffect {
    PsychicSpiralEffect() {
        super(Outcome.GainLife);
        this.staticText = "Shuffle all cards from your graveyard into your library. Target player mills that many cards";
    }

    private PsychicSpiralEffect(PsychicSpiralEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        if (controller != null && targetPlayer != null) {
            int cardsInGraveyard = controller.getGraveyard().size();
            controller.shuffleCardsToLibrary((Cards)controller.getGraveyard(), game, source);
            if (cardsInGraveyard > 0) {
                targetPlayer.millCards(cardsInGraveyard, source, game);
            }
            return true;
        }
        return false;
    }

    public PsychicSpiralEffect copy() {
        return new PsychicSpiralEffect(this);
    }
}

