/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.StackObject;
import mage.players.Player;

class PsychicStrikeEffect
extends OneShotEffect {
    PsychicStrikeEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter target spell. Its controller mills two cards";
    }

    private PsychicStrikeEffect(PsychicStrikeEffect effect) {
        super((OneShotEffect)effect);
    }

    public PsychicStrikeEffect copy() {
        return new PsychicStrikeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller;
        boolean countered = false;
        StackObject stackObject = game.getStack().getStackObject(this.getTargetPointer().getFirst(game, source));
        if (game.getStack().counter(source.getFirstTarget(), source, game)) {
            countered = true;
        }
        if (stackObject != null && (controller = game.getPlayer(stackObject.getControllerId())) != null) {
            controller.millCards(2, source, game);
        }
        return countered;
    }
}

