/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class PublicEnemyEffect
extends RequirementEffect {
    PublicEnemyEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "all creatures attack enchanted creature's controller each combat if able";
    }

    private PublicEnemyEffect(PublicEnemyEffect effect) {
        super((RequirementEffect)effect);
    }

    public PublicEnemyEffect copy() {
        return new PublicEnemyEffect(this);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        Permanent enchantment = game.getPermanent(source.getSourceId());
        Permanent enchantedCreature = game.getPermanent(enchantment.getAttachedTo());
        if (enchantment == null || enchantedCreature == null) {
            return false;
        }
        return !permanent.isControlledBy(enchantedCreature.getControllerId());
    }

    public UUID mustAttackDefender(Ability source, Game game) {
        return Optional.ofNullable(source.getSourcePermanentIfItStillExists(game)).map(Permanent::getAttachedTo).map(arg_0 -> ((Game)game).getControllerId(arg_0)).orElse(null);
    }

    public boolean mustAttack(Game game) {
        return true;
    }

    public boolean mustBlock(Game game) {
        return false;
    }
}

